# Kubernetes with Portworx Volume Driver

This directory primarily consists of two parts
1. Pre-compiled Kubernetes binaries (for linux_amd64) built in with Portworx Volume Driver
2. Source code patch w.r.t release-1.5 branch based of commit #7c187cafeae2853987ab39aa986dbf186b653a6a

## Directory Hierarchy and Contents

* portworx-patch
  - portworx-kubernetes.patch - Patch file containing portworx volume driver
  - portworx-patch-files.txt - List of files changed under the patch

* server/bin
  - All pre-compiled kubernetes server binaries

* client/bin
  - All pre-compiled kubernetes client binaries

* examples/volumes/portworx
  - README for using portworx volume driver
  - Sample yaml spec files

* examples/experimental/persistent-volume-provisiong
  - A few more examples of how to use persistent volume provisioning
  with Portworx

* docs
  - All standard kubernetes docs

## Replacing binaries

The recommended approach is to replace all the binaries under
server/bin so that the installation is smooth. However replacing
following binaries should suffice:

1. kube-controller-manager
2. kube-proxy
3. kube-scheduler
4. kube-apiserver
5. kubectl
6. kubelet


## Running Portworx Container

Once your kubernetes cluster is setup, you need to start the PX
containers on master as well as slave nodes.

You can use the following command:

For CentOS

```
sudo docker run --restart=always --name px -d --net=host \
    --privileged=true                             \
    -v /run/docker/plugins:/run/docker/plugins    \
    -v /var/lib/osd:/var/lib/osd:shared           \
    -v /dev:/dev                                  \
    -v /etc/pwx:/etc/pwx                          \
    -v /opt/pwx/bin:/export_bin                   \
    -v /var/run/docker.sock:/var/run/docker.sock  \
    -v /var/cores:/var/cores                      \
    -v /var/lib/kubelet:/var/lib/kubelet:shared   \
    -v /usr/src:/usr/src                          \
    --ipc=host                                    \
    portworx/px-dev:latest -daemon -k etcd://myetc.company.com:2379 -c
    MY_CLUSTER_ID -s /dev/sdb -s /dev/sdc
```

For CoreOS

```
sudo docker run --restart=always --name px -d --net=host \
   --privileged=true                             \
   -v /run/docker/plugins:/run/docker/plugins    \
   -v /var/lib/osd:/var/lib/osd:shared           \
   -v /dev:/dev                                  \
   -v /etc/pwx:/etc/pwx                          \
   -v /opt/pwx/bin:/export_bin:shared            \
   -v /var/run/docker.sock:/var/run/docker.sock  \
   -v /var/cores:/var/cores                      \
   -v /lib/modules:/lib/modules                  \
   -v /var/lib/kubelet:/var/lib/kubelet:shared   \
   --ipc=host                                    \
   portworx/px-dev:latest -daemon -k etcd://myetc.company.com:4001 -c
   -MY_CLUSTER_ID -s /dev/sdb -s /dev/sdc
```
